<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if($_SESSION['VALID_USER_NAME'] == false)
{
    header("location: login");
}

$comp_id = clean_data($_SESSION["comp_id"]);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $row->acct_name;?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="images/icons/favicon.ico">
    <link rel="apple-touch-icon" href="images/icons/favicon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="images/icons/favicon-72x72.png">
    <link rel="apple-touch-icon" sizes="114x114" href="images/icons/favicon-114x114.png">
    <!--Loading bootstrap css-->
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,400,300,700">
    <link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,700,300">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-ui-1.10.4.custom/css/ui-lightness/jquery-ui-1.10.4.custom.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
    <link type="text/css" rel="stylesheet" href="vendors/bootstrap/css/bootstrap.min.css">
    <!--LOADING STYLESHEET FOR PAGE-->
    <link type="text/css" rel="stylesheet" href="vendors/jquery-tablesorter/themes/blue/style-custom.css">
    <!--Loading style vendors-->
    <link type="text/css" rel="stylesheet" href="vendors/animate.css/animate.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-pace/pace.css">
    <link type="text/css" rel="stylesheet" href="vendors/iCheck/skins/all.css">
    <link type="text/css" rel="stylesheet" href="vendors/jquery-news-ticker/jquery.news-ticker.css">
    <!--Loading style-->
    <link type="text/css" rel="stylesheet" href="css/themes/style3/pink-blue.css" id="theme-change" class="style-change color-change">
    <link type="text/css" rel="stylesheet" href="css/style-responsive.css">
    <!--Select2-->
    <link type="text/css" rel="stylesheet" href="vendors/select2/dist/css/select2.min.css">
</head>
<body class="sidebar-icons">



    <a id="totop" href="#"><i class="fa fa-angle-up"></i></a><!--END BACK TO TOP-->



    <!--BEGIN TOPBAR-->
    <?php include ('header.php'); ?>
    <!--END TOPBAR-->


    <div id="wrapper">
        <!--BEGIN SIDEBAR MENU-->
        <?php include('left.php'); ?>
        <!--END SIDEBAR MENU-->


        <!--BEGIN PAGE WRAPPER-->
        <div id="page-wrapper">
            <div id="title-breadcrumb-option-demo" class="page-title-breadcrumb">
                <div class="page-header pull-left">
                    <div class="page-title">SHOW CHART OF ACCOUNT</div>
                </div>
                <ol class="breadcrumb page-breadcrumb pull-right">
                    <li><i class="fa fa-home"></i>&nbsp;<a href="index">Home</a>&nbsp;&nbsp;<i
                                class="fa fa-angle-right"></i>&nbsp;&nbsp;
                    </li>

                    <li class="active">Show Chart oF Account</li>
                </ol>
                <div class="clearfix"></div>
            </div>
            <!--END TITLE & BREADCRUMB PAGE-->


            <!--BEGIN CONTENT-->
            <div class="page-content">


                <!-------------------------------START FIRST LEVEL------------------------------------>
                <button type="button" data-target="#modal-default" data-toggle="modal" class="btn btn-blue pull-right">Add</button>
                <br clear="all">
                <caption><h3 style="text-align: center"><b>First Level</b></h3></caption>
                <div class="chat-scroller">
                    <table class="table table-bordered table-responsive table-striped table-advanced tablesorter tb-sticky-header"
                           id="datatable_one">

                        <thead>
                        <tr>
                            <th>SR</th>
                            <th>ACCOUNT ID</th>
                            <th>ACCOUNT NAME</th>
                            <th>ACCOUNT TYPE</th>
                            <th>ACTION</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        try {
                            $nom_query = "SELECT n.acct_id, n.acct_name,n.comp_id FROM nom n WHERE length(acct_id) = 2  ORDER BY n.acct_id ";
                            $nom_result = $dbcon->prepare($nom_query);
                            $nom_result->execute(array($comp_id));
                        } catch (PDOException $e) {
                            echo "Error : " . $e->getMessage();
                        }


                        $sr = 0;
                        while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {
                            $sr += 1;
                            ?>
                            <tr>
                                <td><?php echo $sr; ?></td>
                                <td class="btnSelect"><?php echo $nom_row->acct_id; ?></td>
                                <td class="btnSelect"><?php echo $nom_row->acct_name; ?></a></td>
                                <td><?php echo $nom_row->acct_name; ?></a></td>
                                <td>
                                    <a href="#!" class="text-muted"
                                       onclick="GetDetails('<?php echo $nom_row->acct_id; ?>')"><i
                                                class="glyphicon glyphicon-edit"></i></a>

                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                        </tbody>
                    </table>
                </div>


                <!-------------------------START FIRST LEVEL ACCOUNT ADD MODEL--------------->

                <?php

                //MAXIMUM  ID CHK QUERY
                try
                {
                    $Maxquery =  "SELECT LPAD(IFNULL(max(v.acct_id),0)+1,2,'0') acct_id FROM nom v WHERE LENGTH(acct_id) = 2";
                    $max_query = $dbcon->prepare($Maxquery);
                    $max_query->execute(array());
                }
                catch(PDOException $e)
                {
                    echo "Error : ". $e->getMessage();
                }

                $row_max = $max_query->fetch(PDO::FETCH_OBJ);
                $v_id = $row_max->acct_id;

                ?>


                <div id="modal-default" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                                    <h4 id="modal-default-label" class="modal-title">ADD NEW</h4></div>
                                <div class="modal-body">
                                    <div class="form-body pal">
                                        <div class="form-group"><label for="inputEmail" class="control-label">Account ID: <span class='require'>*</span></label>
                                            <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_id" id="acct_id"  class="form-control"  /></div>
                                        </div>

                                        <div class="form-group"><label for="inputEmail" class="control-label">Account Name: <span class='require'>*</span></label>
                                            <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_name" id="acct_name"  class="form-control check_acct_name" /></div>
                                            <span class="result_acctname"></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                                    <button type="button" class="btn btn-primary" onClick="chartofacct_add()">Save changes</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-------------------------END FIRST LEVEL ACCOUNT ADD MODEL--------------->

                    <!-------------------------START EDIT MODEL--------------->
                    <div id="update_user_modal" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade"  >
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                                    <h4 id="modal-default-label" class="modal-title">UPDATE</h4></div>
                                <div class="modal-body">
                                    <div class="form-body pal">

                                        <div class="form-group"><label for="inputEmail" class="control-label">Account ID: <span class='require'>*</span></label>
                                            <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_id" id="update_acct_id"  class="form-control" readonly value="<?php echo $v_id; ?>"/></div>
                                        </div>

                                        <div class="form-group"><label for="inputEmail" class="control-label">Account Name: <span class='require'>*</span></label>
                                            <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_name" id="update_acct_name"  class="form-control check_acct_name" /></div>
                                            <span class="result_acctname"></span>
                                        </div>

                                    </div>
                                </div>


                                <div class="modal-footer">
                                    <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                                    <button type="button" class="btn btn-primary" onClick="UpdateDetails()">Save changes</button>
                                    <input type="hidden" id="hidden_user_id">
                                </div>
                            </div>
                        </div>
                    </div>
                <!-------------------------------END FIRST LEVEL------------------------------------>







                <br clear="all"><br clear="all"><br clear="all">


                <!--------------------------------------START SECOND LEVEL ACCOUNT------------------------------------>




                <caption><h3 style="text-align: center"><b>Second Level</b></h3></caption>


                                <div id="level2"></div>
                                <div class="level2-scroller">
                                    <table id="datatable_second"
                                           class="table table-bordered table-responsive table-striped">
                                        <thead>
                                        <tr>
                                            <th>SR</th>
                                            <th>ACCOUNT ID</th>
                                            <th>ACCOUNT NAME</th>
                                            <th>ACTION</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        try {
                                            $nom_query = "SELECT n.acct_id, n.acct_name,n.comp_id FROM nom n WHERE n.comp_id = ? AND length(acct_id) = 6  ORDER BY n.acct_id ";
                                            $nom_result = $dbcon->prepare($nom_query);
                                            $nom_result->execute(array($comp_id));
                                        } catch (PDOException $e) {
                                            echo "Error : " . $e->getMessage();
                                        }
                                        $sr = 0;
                                        while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {
                                            $sr += 1;

                                            ?>
                                            <tr>
                                                <td><?php echo $sr; ?></td>
                                                <td class="level_second_cell"><?php echo $nom_row->acct_id; ?></td>
                                                <td><?php echo $nom_row->acct_name; ?></td>
                                                <td>
                                                    <a href="#!" class="text-muted"
                                                       onclick="GetDetails_second('<?php echo $nom_row->acct_id; ?>')"><i
                                                                class="glyphicon glyphicon-edit"></i></a>


                                                </td>

                                            </tr>
                                            <?php
                                        }
                                        ?>
                                        </tbody>

                                    </table>
                                </div>


                <!--------------------------------------END SECOND LEVEL ACCOUNT------------------------------------>






                    <!---------------START THIRED LEVEL ACCOUNT---------------->


                <caption><h3 style="text-align: center"><b>Thired Level</b></h3></caption>


                                        <div id="level3"></div>

                                        <div class="level3-scroller">
                                        <table id="datatable_thired"
                                               class="table table-bordered table-responsive table-striped">
                                            <thead>
                                            <tr>
                                                <th>SR</th>
                                                <th>ACCOUNT ID</th>
                                                <th>ACCOUNT NAME</th>
                                                <th>ACTION</th>
                                            </tr>
                                            </thead>
                                            <tbody>


                                            <?php
                                            try {
                                                $nom_query = "SELECT n.acct_id, n.acct_name,n.comp_id FROM nom n WHERE n.comp_id = ? AND length(acct_id) = 10  ORDER BY n.acct_id ";
                                                $nom_result = $dbcon->prepare($nom_query);
                                                $nom_result->execute(array($comp_id));
                                            } catch (PDOException $e) {
                                                echo "Error : " . $e->getMessage();
                                            }

                                            $sr = 0;
                                            while ($nom_row = $nom_result->fetch(PDO::FETCH_OBJ)) {

                                                $sr += 1;

                                                ?>
                                                <tr>
                                                    <td><?php echo $sr; ?></td>
                                                    <td><?php echo $nom_row->acct_id; ?></td>
                                                    <td><?php echo $nom_row->acct_name; ?></td>
                                                    <td>
                                                        <a href="#!" class="text-muted" onclick="GetDetails('<?php echo $nom_row->acct_id;?>')"><i class="glyphicon glyphicon-edit"></i></a>

                                                        <?php
                                                        if (count_child($nom_row->acct_id, 'voucherdet')==0 && count_child_level($nom_row->acct_id,'nom' )==0){
                                                        ?>
                                                        <a  class="text-muted delete_product" data-id="<?php echo $nom_row->acct_id; ?>" href="javascript:void(0)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="glyphicon glyphicon-trash"></i></a>
                                                    <?php } ?>






                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                            ?>
                                            </tbody>

                                        </table>
                                    </div>
                        <!---------------END THIRED LEVEL ACCOUNT---------------->







                <!-------------------------START ADD MODEL--------------->

                <div id="party_modal" tabindex="-1" role="dialog" aria-labelledby="modal-default-label" aria-hidden="true" class="modal fade">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" data-dismiss="modal" aria-hidden="true" class="close">&times;</button>
                                <h4 id="modal-default-label" class="modal-title">ADD NEW ADDRESS</h4></div>
                            <div class="modal-body">
                                <div class="form-body pal">


                                    <div class="form-group"><label for="inputUsername" class="control-label"> ID: <span class='require'>*</span></label>
                                        <div class="input-icon"><i class="fa fa-plus"></i><input name="acct_id" id="p_acct_id"   type="text"  class="form-control" readonly/></div>
                                    </div>


                                    <div class="form-group"><label for="inputEmail" class="control-label">Name <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="acct_name" id="p_acct_name"  class="form-control" readonly/></div>
                                    </div>


                                    <div class="form-group"><label for="inputUsername" class="control-label"> Select Region: <span class='require'>*</span></label>

                                        <?php
                                        try
                                        {
                                            $col_query =  "SELECT r.reg_id, r.reg_name FROM regions r  ORDER BY r.reg_id ASC ";

                                            $col_result = $dbcon->prepare($col_query);
                                            $col_result->execute(array());
                                        }
                                        catch(PDOException $e)
                                        {
                                            echo "Error : ". $e->getMessage();
                                        }

                                        ?>

                                        <select class="form-control" name="reg_id" id="reg_id">
                                            <option></option>
                                            <?php
                                            while($col_row = $col_result->fetch(PDO::FETCH_OBJ))
                                            {
                                                echo '<option  value="' . $col_row->reg_id . '">' . $col_row->reg_id . '-'. $col_row->reg_name . '</option>';

                                            }
                                            ?>

                                        </select>

                                    </div>


                                    <div class="form-group"><label for="inputEmail" class="control-label">Address <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="address" id="address"  class="form-control" /></div>
                                    </div>


                                    <div class="form-group"><label for="inputEmail" class="control-label">Email <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="email" name="email" id="email"  class="form-control" required /></div>
                                    </div>

                                    <div class="form-group"><label for="inputEmail" class="control-label">Phone NO <span class='require'>*</span></label>
                                        <div class="input-group"><span class="input-group-addon"><i class="fa fa-pencil"></i></span><input type="text" name="phone_no" id="phone_no"  class="form-control" placeholder="03211234567" /></div>
                                    </div>


                                </div>
                            </div>


                            <div class="modal-footer">
                                <button type="button" data-dismiss="modal" class="btn btn-default">Close</button>
                                <button type="button" class="btn btn-primary" onClick="party_add()">Save changes</button>
                            </div>


                        </div>
                    </div>
                </div>
                <!-------------------------END ADD MODEL--------------->











































            </div>
        </div>
    </div>

    <script src="js/jquery-1.10.2.min.js"></script>
    <script src="js/jquery-migrate-1.2.1.min.js"></script>
    <script src="js/jquery-ui.js"></script>
    <!--loading bootstrap js-->
    <script src="vendors/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendors/bootstrap-hover-dropdown/bootstrap-hover-dropdown.js"></script>
    <script src="js/html5shiv.js"></script>
    <script src="js/respond.min.js"></script>
    <script src="vendors/metisMenu/jquery.metisMenu.js"></script>
    <script src="vendors/slimScroll/jquery.slimscroll.js"></script>
    <script src="vendors/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendors/iCheck/icheck.min.js"></script>
    <script src="vendors/iCheck/custom.min.js"></script>
    <script src="vendors/jquery-news-ticker/jquery.news-ticker.js"></script>
    <script src="js/jquery.menu.js"></script>
    <script src="vendors/jquery-pace/pace.min.js"></script>
    <script src="vendors/holder/holder.js"></script>
    <script src="vendors/responsive-tabs/responsive-tabs.js"></script>
    <!--LOADING SCRIPTS FOR PAGE-->
    <script src="vendors/jquery-tablesorter/jquery.tablesorter.js"></script>
    <script src="js/table-advanced.js"></script>
    <!--CORE JAVASCRIPT-->
    <script src="js/main.js"></script>
    <!--SELECT2-->
    <script src="vendors/select2/dist/js/select2.full.min.js"></script>
    <!-- BOOT BOX ALERT -->
    <script src="js/bootbox.min.js" type="text/javascript"></script>


    <!---------------------------START JAVASCRIPT-------------------------------->
    <script type="text/javascript">

        /*************START LEVEL ONE SCROLL*********/
        $('.chat-scroller').slimScroll({
            "width": '100%',
            "height": '205px',
            "wheelStep": 10,
            "scrollTo": "100px"
        });
        /*************END LEVEL ONE SCROLL*********/


        /*************START LEVEL TWO SCROLL*********/
        $('.level2-scroller').slimScroll({
            "width": '100%',
            "height": '300px',
            "wheelStep": 5,
            "scrollTo": "100px"
        });
        /*************END LEVEL TWO SCROLL*********/




        /*************START LEVEL THREE SCROLL*********/
        $('.level3-scroller').slimScroll({
            "width": '100%',
            "height": '300px',
            "wheelStep": 5,
            "scrollTo": "100px"
        });
        /*************END LEVEL THREE SCROLL*********/



        $(".acct_id").select2();

        /****************START FIRST LEVEL ACCOUNT SUBMIT FROM AJAX***************/
        function chartofacct_add() {
            var acct_id = $('#acct_id').val();
            var acct_name = $('#acct_name').val();

            var action = 'first_level_form';


            if (acct_id == "") {
                alert("Please Enter Account Id");
                $('#acct_id').focus();
            }
            else if (acct_name == "") {
                alert("Please Enter Account Name");
                $('#acct_name').focus();
            }


            else {
                var dataString = '&acct_id=' + acct_id + '&acct_name=' + acct_name + '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "process/master_process.php",
                    data: dataString,
                    success: function (result) {
                        //alert(result);
                        window.location = "show_chart_of_accounts.php"
                    }
                });

            }

        }
        /****************END FIRST LEVEL ACCOUNT SUBMIT FROM AJAX***************/




        /****************START SECOND LEVEL ACCOUNT SUBMIT FROM AJAX***************/
        function chartofacct_second_add() {
            var second_level_first_acct_id = $('#second_level_first_acct_id').val();
            var second_acct_name = $('#second_acct_name').val();

            var action = "second_level_form";

            if (second_level_first_acct_id == "") {
                alert("Please Select First Level Account");
                $('#first_acct_id').focus();
            }

            else if (second_acct_name == "") {
                alert("Please Enter Account Name");
                $('#second_acct_name').focus();

            }


            else {
                var dataString = 'second_level_first_acct_id=' + second_level_first_acct_id + '&second_acct_name=' + second_acct_name + '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "process/chartofacct_process.php",
                    data: dataString,
                    success: function (result) {
                        //alert(result);
                        window.location = "show_chart_of_accounts.php"

                    }
                });

            }

        }
        /****************END SECOND LEVEL ACCOUNT SUBMIT FROM AJAX***************/













        /****************START FIRST LEVEL ACCOUNT NAME IS AVAILBALE OR NOT***************/

            $(".check_acct_name").keyup(function () {
                var first_acct_name = $(this).val();


                if (first_acct_name.length > 2) {
                    $(".result_acctname").html('checking...');

                    var dataString = 'first_acct_name=' + first_acct_name + '&action=acct_name_one';

                    $.ajax({
                        type: 'POST',
                        url: 'ajax/acctname_live_check.php',
                        data: dataString,
                        success: function (data) {
                            $(".result_acctname").html(data);
                        }
                    });
                    return false;

                }
                else {
                    $(".result_acctname").html('');
                }
            });


        /****************END FIRST LEVEL ACCOUNT NAME IS AVAILBALE OR NOT***************/






        /*******************START GETDETAIL EDIT ID*****************/
        function GetDetails(id) {
            // Add User ID to the hidden field for furture usage
            $("#hidden_user_id").val(id);

            var action = 'edit_chart_of_account';


            var dataString = 'id=' + id +
                '&action=' + action;

            $.ajax({
                type: "POST",
                url: "ajax/get_details.php",
                data: dataString,
                success: function (data, status) {

                    // PARSE json data
                    var user = JSON.parse(data);
                    // Assing existing values to the modal popup fields
                    $("#update_first_acct_id").val(user.acct_id);
                    $("#update_first_acct_name").val(user.acct_name);
                    $("#update_comp_id").val(user.comp_id);
                }
            });

            // Open modal popup
            $("#update_user_modal").modal("show");
        }
        /*******************END GETDETAIL EDIT ID*****************/


        /*******************START UPDATE DETAIL EDIT ID*****************/
        function UpdateDetails() {
            // get values
            var update_first_acct_name = $("#update_first_acct_name").val();
            // get hidden field value
            var id = $("#hidden_user_id").val();

            var action = 'edit_chart_of_account';

            // Update the details by requesting to the server using ajax
            var dataString = 'id=' + id +
                '&update_first_acct_name=' + update_first_acct_name +
                '&action=' + action;
            $.ajax({
                type: "POST",
                url: "ajax/update_details.php",
                data: dataString,
                success: function (data, status) {
                    //alert(data);
                    // hide modal popup
                    $("#update_user_modal").modal("hide");
                    window.location = "show_chart_of_accounts"
                }
            });
        }
        /*******************END UPDATE DETAIL EDIT ID*****************/




        /*******************START SECOND LEVEL GETDETAIL EDIT ID*****************/
        function GetDetails_second(id) {
            // Add User ID to the hidden field for furture usage
           $("#hidden_second_level").val(id);
            var action = 'second_edit_chart_of_account';

            var dataString = 'id=' + id +
                '&action=' + action;

            $.ajax({
                type: "POST",
                url: "ajax/get_details.php",
                data: dataString,
                success: function (data, status) {



                    // PARSE json data
                    var user = JSON.parse(data);
                    // Assing existing values to the modal popup fields
                    $("#update_second_level_first_acct_id").val(user.acct_id);
                    $("#update_second_acct_name").val(user.acct_name);

                }
            });

            // Open modal popup
            $("#update_second_level_modal").modal("show");
        }
        /*******************END SECOND LEVEL GETDETAIL EDIT ID*****************/


        /*******************START UPDATE DETAIL EDIT ID*****************/
        function UpdateDetails_second() {
            // get values
            var update_second_acct_name = $("#update_second_acct_name").val();
            // get hidden field value
            var id = $("#hidden_second_level").val();

            var action = 'second_edit_chart_of_account';

            // Update the details by requesting to the server using ajax
            var dataString = 'id=' + id +
                '&update_second_acct_name=' + update_second_acct_name +
                '&action=' + action;
            $.ajax({
                type: "POST",
                url: "ajax/update_details.php",
                data: dataString,
                success: function (data, status) {
                    //alert(data);
                    // hide modal popup
                    $("#update_second_level_modal").modal("hide");
                    window.location = "show_chart_of_accounts"
                }
            });
        }
        /*******************END UPDATE DETAIL EDIT ID*****************/

























        /*******************START DELETE ITEM*****************/
        $(document).ready(function () {
            $('.delete_product').click(function (e) {
                e.preventDefault();
                var pid = $(this).attr('data-id');
                var parent = $(this).parent("td").parent("tr");
                bootbox.dialog({
                    message: "Are you sure you want to Delete ?",
                    title: "<i class='glyphicon glyphicon-trash'></i> Delete !",
                    buttons: {
                        success: {
                            label: "No",
                            className: "btn-success",
                            callback: function () {
                                $('.bootbox').modal('hide');
                            }
                        },
                        danger: {
                            label: "Delete!",
                            className: "btn-danger",
                            callback: function () {
                                $.post('del_master.php', {'chart_of_acct_delete': pid})
                                    .done(function (response) {
                                        bootbox.alert(response);
                                        parent.fadeOut('slow');
                                    })
                                    .fail(function () {
                                        bootbox.alert('Something Went Wrog ....');
                                    })
                                // window.location = "show_item_description.php"
                            }
                        }
                    }
                });


            });

        });
        /*******************END DELETE ITEM*****************/


























































        /**********************START GET SECOND LEVEL FROM FIRST LEVEL*********************/
        $(document).ready(function(){
            // code to read selected table row cell data (values).
            $("#datatable_one").on('click','.btnSelect',function(){
                // get the current row
                var currentRow=$(this).closest("tr");
                var first_level_acct_id = currentRow.find("td:eq(1)").text(); // get current row 2nd TD
                var action = 'first_level';

                var datastring = 'first_level_acct_id=' + first_level_acct_id  + '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "get_second_level.php",
                    data: datastring,
                    beforeSend: function () {
                        $("#level2").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="images/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                    },
                    success: function (result) {
                        //alert(result)
                        $('#datatable_second').hide();
                        $('#level2').html(result);
                    }
                });
            });
        });
        /**********************END GET SECOND LEVEL FROM FIRST LEVEL*********************/





        /**********************START GET THIRED LEVEL FROM FIRST LEVEL*********************/
        $(document).ready(function(){
            // code to read selected table row cell data (values).
            $("#datatable_one").on('click','.btnSelect',function(){
                // get the current row
                var currentRow=$(this).closest("tr");
                var first_level_acct_id = currentRow.find("td:eq(1)").text(); // get current row 2nd TD
                var action = 'get_thired';

                var datastring = 'first_level_acct_id=' + first_level_acct_id  + '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "get_second_level.php",
                    data: datastring,
                    beforeSend: function () {
                        $("#level3").html('<div align="center"><font style="font-family:Verdana, Geneva, sans-serif; font-size:15px; color:black;"></font> Loading.... <img src="images/ajax-loader.gif" alt="Loading...." align="absmiddle" title="Loading...."/></div><br clear="all">');
                    },
                    success: function (result) {
                        //alert(result)
                        $('#datatable_thired').hide();
                        $('#level3').html(result);
                    }
                });
            });
        });
        /**********************END GET THIRED LEVEL FROM FIRST LEVEL*********************/








        /*******************START GETDETAIL PARTY ID*****************/
        function get_party_id(id) {
            // Add User ID to the hidden field for furture usage
             $("#hidden_user_id").val(id);

            var action = 'p_address';


            var dataString = 'id=' + id +
                '&action=' + action;

            $.ajax({
                type: "POST",
                url: "ajax/get_details.php",
                data: dataString,
                success: function (data, status) {

                    // PARSE json data
                    var user = JSON.parse(data);
                    // Assing existing values to the modal popup fields
                    $("#p_acct_id").val(user.acct_id);
                    $("#p_acct_name").val(user.acct_name);

                }
            });

            // Open modal popup
            $("#party_modal").modal("show");
        }
        /*******************END GETDETAIL EDIT ID*****************/



        /****************START PARTY ADDRESS FROM AJAX***************/
        function party_add() {
            var p_acct_id = $('#p_acct_id').val();
            var p_acct_name = $('#p_acct_name').val();
            var reg_id = $('#reg_id').val();
            var address = $('#address').val();
            var email = $('#email').val();
            var phone_no = $('#phone_no').val();


            var action = 'party_address_add';


            if (reg_id == "") {
                alert("Please Select Region ID");
                $('#reg_id').focus();
            }
            else if (address == "") {
                alert("Please Enter Address.");
                $('#address').focus();
            }


            else {
                var dataString = '&p_acct_id=' + p_acct_id +
                    '&p_acct_name=' + p_acct_name +
                    '&reg_id=' + reg_id +
                    '&address=' + address +
                    '&email=' + email +
                    '&phone_no=' + phone_no +
                    '&action=' + action;

                $.ajax({
                    type: "POST",
                    url: "process/master_process.php",
                    data: dataString,
                    success: function (result) {
                        //alert(result);
                        window.location = "show_chart_of_accounts.php"
                    }
                });

            }

        }
        /****************END PARTY ADDRESS FROM AJAX***************/







    </script>
    <!---------------------------END JAVASCRIPT-------------------------------->




</body>
</html>
